/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.index;

import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.Score;
import org.snapscript.core.function.ArgumentConverter;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Signature;
import org.snapscript.core.function.index.FunctionIndexer;
import org.snapscript.core.function.index.FunctionPointer;
import org.snapscript.core.function.index.LocalFunctionIndexer;
import org.snapscript.core.function.index.TracePointer;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.index.LocalScopeFinder;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;

public class LocalIndexer {
    private final LocalFunctionIndexer indexer;
    private final LocalScopeFinder finder;
    private final ThreadStack stack;

    public LocalIndexer(ThreadStack stack, FunctionIndexer indexer) {
        this.indexer = new LocalFunctionIndexer(indexer);
        this.finder = new LocalScopeFinder();
        this.stack = stack;
    }

    public FunctionPointer index(Scope scope, String name, Type ... types) throws Exception {
        Constraint constraint;
        Type type;
        Value value = this.finder.findFunction(scope, name);
        if (value != null && (type = (constraint = value.getConstraint()).getType(scope)) != null) {
            Function function;
            Signature signature;
            ArgumentConverter match;
            Score score;
            List<Function> functions = type.getFunctions();
            int modifiers = type.getModifiers();
            if (ModifierType.isFunction(modifiers) && !functions.isEmpty() && (score = (match = (signature = (function = functions.get(0)).getSignature()).getConverter()).score(types)).isValid()) {
                return new TracePointer(function, this.stack);
            }
        }
        return this.indexer.index(scope, name, types);
    }

    public FunctionPointer index(Scope scope, String name, Object ... values) throws Exception {
        Function function;
        Signature signature;
        ArgumentConverter match;
        Score score;
        Object object;
        Value value = this.finder.findFunction(scope, name);
        if (value != null && (object = value.getValue()) != null && Function.class.isInstance(object) && (score = (match = (signature = (function = (Function)object).getSignature()).getConverter()).score(values)).isValid()) {
            return new TracePointer(function, this.stack);
        }
        return this.indexer.index(scope, name, values);
    }
}

