/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.index;

import org.snapscript.core.attribute.AttributeResult;
import org.snapscript.core.attribute.AttributeResultBinder;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.ArgumentConverter;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.Origin;
import org.snapscript.core.function.Signature;
import org.snapscript.core.function.index.FunctionPointer;
import org.snapscript.core.function.index.Retention;
import org.snapscript.core.function.index.ReturnType;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.stack.ThreadStack;

public class TracePointer
implements FunctionPointer {
    private final AttributeResultBinder binder;
    private final Invocation invocation;
    private final Function function;

    public TracePointer(Function function, ThreadStack stack) {
        this.binder = new AttributeResultBinder(function);
        this.invocation = new TraceInvocation(function, stack);
        this.function = function;
    }

    @Override
    public ReturnType getType(Scope scope) {
        AttributeResult result = this.binder.bind(scope);
        if (result == null) {
            throw new InternalStateException("No return type for '" + this.function + "'");
        }
        return new ReturnType(result, scope);
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    @Override
    public Invocation getInvocation() {
        return this.invocation;
    }

    @Override
    public Retention getRetention() {
        return Retention.NEVER;
    }

    public String toString() {
        return String.valueOf(this.function);
    }

    private static class TraceInvocation
    implements Invocation {
        private final ThreadStack stack;
        private final Function function;

        public TraceInvocation(Function function, ThreadStack stack) {
            this.function = function;
            this.stack = stack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Scope scope, Object object, Object ... arguments) throws Exception {
            Signature signature = this.function.getSignature();
            ArgumentConverter converter = signature.getConverter();
            Invocation invocation = this.function.getInvocation();
            Origin origin = signature.getOrigin();
            try {
                Object[] list = arguments;
                if (!origin.isSystem()) {
                    this.stack.before(this.function);
                }
                list = origin.isPlatform() ? converter.convert(arguments) : converter.assign(arguments);
                Object object2 = invocation.invoke(scope, object, list);
                return object2;
            }
            finally {
                if (!origin.isSystem()) {
                    this.stack.after(this.function);
                }
            }
        }
    }
}

