/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function.index;

import java.util.List;
import org.snapscript.core.EntityCache;
import org.snapscript.core.ModifierType;
import org.snapscript.core.convert.TypeInspector;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.index.FunctionIndex;
import org.snapscript.core.function.index.FunctionIndexBuilder;
import org.snapscript.core.function.index.FunctionPathFinder;
import org.snapscript.core.function.index.FunctionPointer;
import org.snapscript.core.function.index.FunctionPointerConverter;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;

public class TypeStaticIndexer {
    private final EntityCache<FunctionIndex> indexes;
    private final FunctionPointerConverter converter;
    private final FunctionIndexBuilder builder;
    private final FunctionPathFinder finder;
    private final TypeInspector inspector;

    public TypeStaticIndexer(TypeExtractor extractor, ThreadStack stack) {
        this.builder = new FunctionIndexBuilder(extractor, stack);
        this.indexes = new EntityCache();
        this.converter = new FunctionPointerConverter(stack);
        this.finder = new FunctionPathFinder();
        this.inspector = new TypeInspector();
    }

    public FunctionPointer index(Type type, String name, Type ... values) throws Exception {
        FunctionIndex match = this.indexes.fetch(type);
        if (match == null) {
            List<Type> path = this.finder.findPath(type);
            FunctionIndex table = this.builder.create(type);
            int size = path.size();
            for (int i = size - 1; i >= 0; --i) {
                Type entry = path.get(i);
                List<Function> functions = entry.getFunctions();
                for (Function function : functions) {
                    int modifiers = function.getModifiers();
                    if (!ModifierType.isStatic(modifiers) || this.inspector.isSuperConstructor(type, function)) continue;
                    FunctionPointer pointer = this.converter.convert(function);
                    table.index(pointer);
                }
            }
            this.indexes.cache(type, table);
            return table.resolve(name, values);
        }
        return match.resolve(name, values);
    }

    public FunctionPointer index(Type type, String name, Object ... values) throws Exception {
        FunctionIndex match = this.indexes.fetch(type);
        if (match == null) {
            List<Type> path = this.finder.findPath(type);
            FunctionIndex table = this.builder.create(type);
            int size = path.size();
            for (int i = size - 1; i >= 0; --i) {
                Type entry = path.get(i);
                List<Function> functions = entry.getFunctions();
                for (Function function : functions) {
                    int modifiers = function.getModifiers();
                    if (!ModifierType.isStatic(modifiers) || this.inspector.isSuperConstructor(type, function)) continue;
                    FunctionPointer pointer = this.converter.convert(function);
                    table.index(pointer);
                }
            }
            this.indexes.cache(type, table);
            return table.resolve(name, values);
        }
        return match.resolve(name, values);
    }
}

