/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.LinkedHashSet;
import java.util.Set;
import org.snapscript.common.io.PropertyReader;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.link.DefaultImport;

public class DefaultImportReader
extends PropertyReader<DefaultImport> {
    private static final String WILD = "*";

    public DefaultImportReader(String file) {
        super(file);
    }

    @Override
    protected DefaultImport create(String name, char[] data, int off, int length, int line) {
        Set<String> imports = this.createImports(data, off, length, line);
        Set<String> modules = this.createModules(data, off, length, line);
        if (imports.remove(WILD)) {
            return new DefaultImport(imports, modules, name, true);
        }
        return new DefaultImport(imports, modules, name);
    }

    private Set<String> createImports(char[] data, int off, int length, int line) {
        int count;
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        for (int i = count = length + off - 1; i >= 0; --i) {
            char next = data[i];
            if (this.delimiter(next) && count > i) {
                String token = this.format(data, i + 1, count - i);
                imports.add(token);
                count = i - 1;
            }
            if (!this.group(next)) continue;
            return imports;
        }
        throw new InternalStateException("Error with imports from '" + this.file + "' at line " + line);
    }

    private Set<String> createModules(char[] data, int off, int length, int line) {
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        int count = length + off;
        for (int i = off; i < count; ++i) {
            char next = data[i];
            if (this.delimiter(next) && i > off) {
                String token = this.format(data, off, i - off);
                packages.add(token);
                off = i + 1;
            }
            if (!this.group(next)) continue;
            return packages;
        }
        throw new InternalStateException("Error with package from '" + this.file + "' at line " + line);
    }

    private boolean group(char value) {
        return value == '{';
    }

    private boolean delimiter(char value) {
        return value == ',' || value == '{';
    }

    @Override
    protected boolean terminal(char value) {
        return value == '}';
    }
}

