/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.List;
import org.snapscript.common.BitSet;
import org.snapscript.core.NameChecker;
import org.snapscript.core.link.ImportManager;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;

public class ImplicitImportLoader {
    private final NameChecker checker = new NameChecker(true);

    public boolean loadImports(Scope scope, String name) throws Exception {
        if (this.checker.isEntity(name)) {
            Module module = scope.getModule();
            ImportManager manager = module.getManager();
            State state = scope.getState();
            Value value = state.getValue(name);
            if (value == null) {
                return manager.getImport(name) != null;
            }
            return true;
        }
        return false;
    }

    public boolean loadImports(Scope scope, List<String> names) throws Exception {
        int count = names.size();
        if (count > 0) {
            BitSet done = new BitSet(count);
            for (Type type = scope.getType(); type != null; type = type.getOuter()) {
                Scope inner = type.getScope();
                if (!this.loadImports(inner, names, done)) continue;
                return true;
            }
            return this.loadImports(scope, names, done);
        }
        return true;
    }

    private boolean loadImports(Scope scope, List<String> names, BitSet done) throws Exception {
        int count;
        int remain = count = names.size();
        for (int i = 0; i < count; ++i) {
            if (!done.get(i)) {
                String name = names.get(i);
                if (!this.loadImports(scope, name)) continue;
                done.set(i);
                --remain;
                continue;
            }
            --remain;
        }
        return remain <= 0;
    }
}

