/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.snapscript.core.Entity;
import org.snapscript.core.NameFormatter;
import org.snapscript.core.link.ImportTaskBuilder;
import org.snapscript.core.module.FilePathConverter;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.module.PathConverter;

public class ImportEntityFinder {
    private final ConcurrentMap<Path, Future<Entity>> entities = new ConcurrentHashMap<Path, Future<Entity>>();
    private final ImportTaskBuilder builder;
    private final PathConverter converter;
    private final NameFormatter formatter;
    private final Executor executor;

    public ImportEntityFinder(Module parent, Executor executor, Path from) {
        this.builder = new ImportTaskBuilder(parent, executor, from);
        this.converter = new FilePathConverter();
        this.formatter = new NameFormatter();
        this.executor = executor;
    }

    public Future<Entity> findEntity(String module, String name) throws Exception {
        String qualifier = this.formatter.formatFullName(module, name);
        Path path = this.converter.createPath(qualifier);
        Callable<Entity> task = this.builder.createTask(module, name, path);
        if (task != null) {
            FutureTask<Entity> future = new FutureTask<Entity>(task);
            if (this.entities.putIfAbsent(path, future) == null) {
                if (this.executor != null) {
                    this.executor.execute(future);
                } else {
                    future.run();
                }
                return future;
            }
            return (Future)this.entities.get(path);
        }
        return null;
    }
}

