/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.snapscript.core.Context;
import org.snapscript.core.Entity;
import org.snapscript.core.NameFormatter;
import org.snapscript.core.link.ImportEntityFinder;
import org.snapscript.core.link.ImportManager;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.ModuleRegistry;
import org.snapscript.core.module.Path;

public class ImportMatcher {
    private final ImportEntityFinder finder;
    private final NameFormatter formatter;
    private final Module parent;
    private final String from;

    public ImportMatcher(Module parent, Executor executor, Path path, String from) {
        this.finder = new ImportEntityFinder(parent, executor, path);
        this.formatter = new NameFormatter();
        this.parent = parent;
        this.from = from;
    }

    public Future<? extends Entity> matchImport(Set<String> imports, String name) throws Exception {
        Context context = this.parent.getContext();
        ModuleRegistry registry = context.getRegistry();
        for (String string : imports) {
            ImportManager manager;
            Future<Entity> entity;
            Module match = registry.getModule(string);
            if (match == this.parent || match == null || (entity = (manager = match.getManager()).getImport(name)) == null) continue;
            return entity;
        }
        for (String string : imports) {
            Future<Entity> entity = this.finder.findEntity(string, name);
            if (entity == null) continue;
            return entity;
        }
        String type = this.formatter.formatFullName(this.from, name);
        Module module = registry.getModule(type);
        if (module == null) {
            return this.finder.findEntity(this.from, name);
        }
        return null;
    }
}

