/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.snapscript.core.link.ImportPath;
import org.snapscript.core.link.ImportPathSource;

public class ImportPathResolver {
    private final ImportPathSource source;

    public ImportPathResolver(String file) {
        this.source = new ImportPathSource(file);
    }

    public String resolveName(String resource) {
        ImportPath path = this.source.getPath();
        Map<String, Set<String>> aliases = path.getAliases();
        Set<String> names = aliases.keySet();
        for (String name : names) {
            Set<String> modules = aliases.get(name);
            for (String module : modules) {
                if (!resource.startsWith(module)) continue;
                return resource.replace(module, name);
            }
        }
        return resource;
    }

    public List<String> resolvePath(String resource) {
        int index = resource.indexOf(46);
        if (index != -1) {
            return this.resolveAliasPath(resource, index);
        }
        return this.resolveTypePath(resource);
    }

    private List<String> resolveAliasPath(String resource, int index) {
        String token;
        ImportPath path = this.source.getPath();
        Map<String, Set<String>> aliases = path.getAliases();
        Set<String> modules = aliases.get(token = resource.substring(0, index));
        if (modules != null) {
            String remainder = resource.substring(index);
            int count = modules.size();
            if (count > 0) {
                ArrayList<String> list = new ArrayList<String>();
                StringBuilder builder = new StringBuilder();
                for (String module : modules) {
                    builder.append(module);
                    builder.append(remainder);
                    String absolute = builder.toString();
                    list.add(absolute);
                    builder.setLength(0);
                }
                list.add(resource);
                return list;
            }
            return Collections.emptyList();
        }
        return Collections.singletonList(resource);
    }

    private List<String> resolveTypePath(String resource) {
        ImportPath path = this.source.getPath();
        Map<String, Set<String>> types = path.getTypes();
        Set<String> modules = types.get(resource);
        if (modules != null) {
            int count = modules.size();
            if (count > 0) {
                ArrayList<String> list = new ArrayList<String>();
                StringBuilder builder = new StringBuilder();
                for (String module : modules) {
                    builder.append(module);
                    builder.append(".");
                    builder.append(resource);
                    String absolute = builder.toString();
                    list.add(absolute);
                    builder.setLength(0);
                }
                return list;
            }
            return Collections.emptyList();
        }
        return this.resolveDefaultPath(resource);
    }

    private List<String> resolveDefaultPath(String resource) {
        ImportPath path = this.source.getPath();
        Set<String> defaults = path.getDefaults();
        if (resource != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            for (String prefix : defaults) {
                builder.append(prefix);
                builder.append(".");
                builder.append(resource);
                String entry = builder.toString();
                list.add(entry);
                builder.setLength(0);
            }
            return list;
        }
        return Collections.emptyList();
    }
}

