/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.snapscript.core.link.DefaultImport;
import org.snapscript.core.link.DefaultImportReader;
import org.snapscript.core.link.ImportPath;

public class ImportPathSource {
    private volatile DefaultImportReader reader;
    private volatile ImportPath path;

    public ImportPathSource(String file) {
        this.reader = new DefaultImportReader(file);
    }

    public ImportPath getPath() {
        if (this.path == null) {
            DefaultPath local = new DefaultPath();
            for (DefaultImport entry : this.reader) {
                Set<String> imports = entry.getImports();
                Set<String> modules = entry.getModules();
                String name = entry.getAlias();
                if (entry.isInclude()) {
                    local.defaults.addAll(modules);
                }
                for (String type : imports) {
                    local.types.put(type, modules);
                }
                local.aliases.put(name, modules);
            }
            this.path = local;
        }
        return this.path;
    }

    private static class DefaultPath
    implements ImportPath {
        private final Map<String, Set<String>> aliases = new LinkedHashMap<String, Set<String>>();
        private final Map<String, Set<String>> types = new LinkedHashMap<String, Set<String>>();
        private final Set<String> defaults = new LinkedHashSet<String>();

        @Override
        public Map<String, Set<String>> getAliases() {
            return this.aliases;
        }

        @Override
        public Map<String, Set<String>> getTypes() {
            return this.types;
        }

        @Override
        public Set<String> getDefaults() {
            return this.defaults;
        }
    }
}

