/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.snapscript.common.Cache;
import org.snapscript.common.LazyBuilder;
import org.snapscript.common.LazyCache;
import org.snapscript.core.Context;
import org.snapscript.core.Entity;
import org.snapscript.core.NameChecker;
import org.snapscript.core.NameFormatter;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.link.ImportEntityResolver;
import org.snapscript.core.link.ImportFuture;
import org.snapscript.core.link.ImportManager;
import org.snapscript.core.link.ImportMatcher;
import org.snapscript.core.module.FilePathConverter;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.module.PathConverter;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeLoader;

public class ImportProcessor
implements ImportManager {
    private final Map<String, Type> generics = new ConcurrentHashMap<String, Type>();
    private final Map<String, String> aliases = new ConcurrentHashMap<String, String>();
    private final Set<String> imports = new CopyOnWriteArraySet<String>();
    private final ImportMatcher matcher;
    private final EntityFinder finder;
    private final Module parent;
    private final String from;
    private final String local;

    public ImportProcessor(Module parent, Executor executor, Path path, String from, String local) {
        this.matcher = new ImportMatcher(parent, executor, path, from);
        this.finder = new EntityFinder(parent);
        this.parent = parent;
        this.local = local;
        this.from = from;
    }

    @Override
    public void addImport(String prefix) {
        this.imports.add(prefix);
    }

    @Override
    public void addImport(String type, String alias) {
        this.aliases.put(alias, type);
    }

    @Override
    public void addImport(Type type, String alias) {
        this.generics.put(alias, type);
    }

    @Override
    public void addImports(Module module) {
        ImportManager manager = module.getManager();
        if (manager != null) {
            Set<String> types = this.aliases.keySet();
            for (String type : types) {
                String alias = this.aliases.get(type);
                if (alias == null) continue;
                manager.addImport(type, alias);
            }
            for (String value : this.imports) {
                manager.addImport(value);
            }
        }
    }

    public Type getType(String name) throws Exception {
        Entity entity;
        Future<Entity> future = this.getImport(name);
        if (future != null && Type.class.isInstance(entity = future.get())) {
            return (Type)entity;
        }
        return null;
    }

    public Module getModule(String name) throws Exception {
        Entity entity;
        Future<Entity> future = this.getImport(name);
        if (future != null && Module.class.isInstance(entity = future.get())) {
            return (Module)entity;
        }
        return null;
    }

    @Override
    public Future<Entity> getImport(String name) {
        return this.finder.find(name);
    }

    private class EntityResolver {
        private final ImportEntityResolver resolver;
        private final PathConverter converter;
        private final NameFormatter formatter;

        public EntityResolver(Module parent) {
            this.resolver = new ImportEntityResolver(parent);
            this.converter = new FilePathConverter();
            this.formatter = new NameFormatter();
        }

        public Future<Entity> resolve(String name) throws Exception {
            String origin = this.formatter.formatLocalName(name);
            Future<Entity> entity = this.resolveGeneric(name);
            if (entity == null) {
                entity = this.resolveImport(name);
            }
            if (entity == null) {
                entity = this.resolveImport(origin);
            }
            if (entity == null) {
                entity = this.resolveDefault(name);
            }
            if (entity == null) {
                entity = this.resolveLocal(name);
            }
            return entity;
        }

        private Future<Entity> resolveGeneric(String name) throws Exception {
            Entity entity = (Entity)ImportProcessor.this.generics.get(name);
            if (entity != null) {
                return new ImportFuture<Entity>(entity);
            }
            return null;
        }

        private Future<Entity> resolveImport(String name) throws Exception {
            Entity entity;
            String alias = (String)ImportProcessor.this.aliases.get(name);
            int index = name.indexOf(".");
            if (alias != null) {
                String suffix = this.formatter.formatShortName(name);
                String prefix = this.converter.createModule(alias);
                entity = this.resolver.resolveEntity(alias);
                if (entity == null) {
                    entity = this.resolver.resolveEntity(prefix, suffix);
                }
                if (entity != null) {
                    return new ImportFuture<Entity>(entity);
                }
            }
            if (index == -1) {
                for (String module : ImportProcessor.this.imports) {
                    entity = this.resolver.resolveEntity(module, name);
                    if (entity == null) continue;
                    return new ImportFuture<Entity>(entity);
                }
            }
            return null;
        }

        private Future<Entity> resolveLocal(String name) throws Exception {
            Context context = ImportProcessor.this.parent.getContext();
            TypeLoader loader = context.getLoader();
            String origin = this.formatter.formatLocalName(name);
            int index = name.indexOf(".");
            if (index == -1) {
                Type entity = loader.loadType(ImportProcessor.this.from, name);
                if (entity == null) {
                    Future<Entity> future = ImportProcessor.this.matcher.matchImport(ImportProcessor.this.imports, origin);
                    if (name.endsWith(origin)) {
                        return future;
                    }
                    entity = loader.loadType(ImportProcessor.this.from, name);
                }
                if (entity != null) {
                    return new ImportFuture<Entity>(entity);
                }
            }
            return null;
        }

        private Future<Entity> resolveDefault(String name) throws Exception {
            Context context = ImportProcessor.this.parent.getContext();
            TypeLoader loader = context.getLoader();
            Type entity = loader.loadType(null, name);
            if (entity != null) {
                return new ImportFuture<Entity>(entity);
            }
            return null;
        }
    }

    private class EntityFinder
    implements LazyBuilder<String, Future<Entity>> {
        private final Cache<String, Future<Entity>> cache = new LazyCache<String, Future<Entity>>(this);
        private final EntityResolver resolver;
        private final NameFormatter formatter;
        private final NameChecker filter;

        public EntityFinder(Module parent) {
            this.resolver = new EntityResolver(parent);
            this.formatter = new NameFormatter();
            this.filter = new NameChecker(true);
        }

        public Future<Entity> find(String name) {
            return this.cache.fetch(name);
        }

        @Override
        public Future<Entity> create(String name) {
            try {
                String inner = this.formatter.formatInnerName(name);
                String origin = this.formatter.formatLocalName(name);
                if (!this.filter.isEntity(inner)) {
                    return null;
                }
                if (!this.filter.isEntity(origin)) {
                    return null;
                }
                if (origin.equals(ImportProcessor.this.local)) {
                    return new ImportFuture<Entity>(ImportProcessor.this.parent);
                }
                return this.resolver.resolve(name);
            }
            catch (Exception e) {
                throw new InternalStateException("Could not find '" + name + "' in '" + ImportProcessor.this.from + "'", e);
            }
        }
    }
}

