/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.NameFormatter;
import org.snapscript.core.ResourceManager;
import org.snapscript.core.link.ImportLoader;
import org.snapscript.core.link.ImportPathResolver;

public class ImportScanner {
    private final Cache<String, Package> packages = new CopyOnWriteCache<String, Package>();
    private final Cache<String, Class> types;
    private final Cache<Object, String> names = new CopyOnWriteCache<Object, String>();
    private final ImportPathResolver selector;
    private final NameFormatter formatter;
    private final ImportLoader loader;
    private final Set<String> failures;

    public ImportScanner(ResourceManager manager) {
        this(manager, "import.txt");
    }

    public ImportScanner(ResourceManager manager, String file) {
        this.types = new CopyOnWriteCache<String, Class>();
        this.failures = new CopyOnWriteArraySet<String>();
        this.selector = new ImportPathResolver(file);
        this.formatter = new NameFormatter();
        this.loader = new ImportLoader();
    }

    public Package importPackage(String name) {
        if (!this.failures.contains(name)) {
            Package result = this.packages.fetch(name);
            if (result == null) {
                List<String> paths = this.selector.resolvePath(name);
                for (String path : paths) {
                    result = this.loadPackage(path);
                    if (result == null) continue;
                    this.packages.cache(name, result);
                    return result;
                }
                this.failures.add(name);
            }
            return result;
        }
        return null;
    }

    public Class importType(String name) {
        if (!this.failures.contains(name)) {
            Class type = this.types.fetch(name);
            if (type == null) {
                List<String> paths = this.selector.resolvePath(name);
                for (String path : paths) {
                    type = this.loadType(path);
                    if (type == null) continue;
                    this.types.cache(name, type);
                    return type;
                }
                this.failures.add(name);
            }
            return type;
        }
        return null;
    }

    public Class importType(String name, int size) {
        Class type = this.importType(name);
        if (type != null && size < 4) {
            Object array = null;
            if (size > 0) {
                if (size == 1) {
                    array = Array.newInstance(type, 0);
                } else if (size == 2) {
                    array = Array.newInstance(type, 0, 0);
                } else if (size == 3) {
                    array = Array.newInstance(type, 0, 0, 0);
                }
                return array.getClass();
            }
            return type;
        }
        return null;
    }

    public String importName(Class type) {
        String result = this.names.fetch(type);
        if (result == null) {
            String absolute = this.formatter.formatFullName(type);
            String name = this.selector.resolveName(absolute);
            this.types.cache(absolute, type);
            this.types.cache(name, type);
            this.names.cache(type, name);
            return name;
        }
        return result;
    }

    public String importName(Package module) {
        String result = this.names.fetch(module);
        if (result == null) {
            String absolute = module.getName();
            String name = this.selector.resolveName(absolute);
            this.packages.cache(absolute, module);
            this.packages.cache(name, module);
            this.names.cache(module, name);
            return name;
        }
        return result;
    }

    private Class loadType(String name) {
        try {
            Class result = this.loader.loadClass(name);
            if (result != null) {
                this.types.cache(name, result);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Package loadPackage(String name) {
        try {
            Package result = this.loader.loadPackage(name);
            if (result != null) {
                this.packages.cache(name, result);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

