/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import org.snapscript.core.Context;
import org.snapscript.core.Entity;
import org.snapscript.core.Execution;
import org.snapscript.core.NameFormatter;
import org.snapscript.core.Statement;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.link.ImportEntityResolver;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageDefinition;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.TypeLoader;

public class ImportTaskBuilder {
    private final ImportEntityResolver resolver;
    private final NameFormatter formatter;
    private final Executor executor;
    private final Module parent;
    private final Set failures;
    private final Set imports;
    private final Path from;

    public ImportTaskBuilder(Module parent, Executor executor, Path from) {
        this.resolver = new ImportEntityResolver(parent);
        this.failures = new CopyOnWriteArraySet();
        this.imports = new CopyOnWriteArraySet();
        this.formatter = new NameFormatter();
        this.executor = executor;
        this.parent = parent;
        this.from = from;
    }

    public Callable<Entity> createTask(String module, String name, Path path) throws Exception {
        if (!this.failures.contains(path)) {
            try {
                String qualifier = this.formatter.formatFullName(module, name);
                Context context = this.parent.getContext();
                TypeLoader loader = context.getLoader();
                Package entity = loader.importType(qualifier);
                Package bundle = loader.importType(module, name);
                return new DefineImport(bundle, entity, path, qualifier);
            }
            catch (Exception e) {
                this.failures.add(path);
            }
        }
        return null;
    }

    private class CompileImport
    implements Runnable {
        private final Statement statement;
        private final Path path;

        public CompileImport(Statement statement, Path path) {
            this.statement = statement;
            this.path = path;
        }

        @Override
        public void run() {
            try {
                Scope scope = ImportTaskBuilder.this.parent.getScope();
                Execution execution = this.statement.compile(scope, null);
                execution.execute(scope);
            }
            catch (Exception e) {
                throw new InternalStateException("Could not compile import '" + this.path + "'", e);
            }
        }
    }

    private class DefineImport
    implements Callable<Entity> {
        private final Package bundle;
        private final String name;
        private final Path path;

        public DefineImport(Package bundle, Package entity, Path path, String name) {
            this.bundle = bundle;
            this.name = name;
            this.path = path;
        }

        @Override
        public Entity call() {
            try {
                if (!ImportTaskBuilder.this.imports.contains(this.path)) {
                    Scope scope = ImportTaskBuilder.this.parent.getScope();
                    PackageDefinition definition = this.bundle.create(scope);
                    Statement statement = definition.define(scope, ImportTaskBuilder.this.from);
                    if (ImportTaskBuilder.this.imports.add(this.path)) {
                        CompileImport task = new CompileImport(statement, this.path);
                        if (ImportTaskBuilder.this.executor != null) {
                            ImportTaskBuilder.this.executor.execute(task);
                        } else {
                            task.run();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new InternalStateException("Could not import '" + this.path + "'", e);
            }
            return ImportTaskBuilder.this.resolver.resolveEntity(this.name);
        }
    }
}

