/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.link.PackageDefinition;
import org.snapscript.core.module.Path;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;

public class PackageDefinitionList
implements PackageDefinition {
    private final List<PackageDefinition> definitions;

    public PackageDefinitionList(List<PackageDefinition> definitions) {
        this.definitions = definitions;
    }

    @Override
    public Statement define(Scope scope, Path from) throws Exception {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (PackageDefinition definition : this.definitions) {
            Statement statement = definition.define(scope, from);
            if (statement == null) continue;
            statements.add(statement);
        }
        return new StatementList(statements);
    }

    private static class ExecutionList
    extends Execution {
        private final List<Execution> statements;

        public ExecutionList(List<Execution> statements) {
            this.statements = statements;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            Result result = Result.NORMAL;
            for (Execution statement : this.statements) {
                Result next = statement.execute(scope);
                if (!next.isNormal()) {
                    return next;
                }
                result = next;
            }
            return result;
        }
    }

    private static class StatementList
    extends Statement {
        private final List<Statement> statements;

        public StatementList(List<Statement> statements) {
            this.statements = statements;
        }

        @Override
        public void create(Scope scope) throws Exception {
            for (Statement statement : this.statements) {
                statement.create(scope);
            }
        }

        @Override
        public boolean define(Scope scope) throws Exception {
            for (Statement statement : this.statements) {
                statement.define(scope);
            }
            return true;
        }

        @Override
        public Execution compile(Scope scope, Constraint returns) throws Exception {
            ArrayList<Execution> executions = new ArrayList<Execution>();
            for (Statement statement : this.statements) {
                Execution next = statement.compile(scope, null);
                executions.add(next);
            }
            return new ExecutionList(executions);
        }
    }
}

