/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.List;
import org.snapscript.core.ResourceManager;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.link.ImportType;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageBundle;
import org.snapscript.core.link.PackageBundleLoader;
import org.snapscript.core.link.PackageBundleMerger;
import org.snapscript.core.link.PackageLinker;
import org.snapscript.core.module.FilePathConverter;
import org.snapscript.core.module.Path;
import org.snapscript.core.module.PathConverter;

public class PackageLoader {
    private final PackageBundleLoader loader;
    private final PackageBundleMerger merger;
    private final PathConverter converter = new FilePathConverter();

    public PackageLoader(PackageLinker linker, ResourceManager manager) {
        this.loader = new PackageBundleLoader(linker, manager, this.converter);
        this.merger = new PackageBundleMerger();
    }

    public Package load(ImportType type, String ... resources) throws Exception {
        PackageBundle bundle = this.loader.load(resources);
        List<Package> packages = bundle.getPackages();
        if (packages.isEmpty() && type.isRequired()) {
            StringBuilder message = new StringBuilder();
            for (String resource : resources) {
                Path path = this.converter.createPath(resource);
                int size = message.length();
                if (size > 0) {
                    message.append(" or ");
                }
                message.append("'");
                message.append(path);
                message.append("'");
            }
            throw new InternalStateException("Could not load library " + message);
        }
        return this.merger.merge(bundle);
    }
}

