/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import org.snapscript.core.NameFormatter;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.link.ImportScanner;
import org.snapscript.core.link.ImportType;
import org.snapscript.core.link.NoPackage;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageLoader;

public class PackageManager {
    private final NameFormatter formatter = new NameFormatter();
    private final ImportScanner scanner;
    private final PackageLoader loader;

    public PackageManager(PackageLoader loader, ImportScanner scanner) {
        this.scanner = scanner;
        this.loader = loader;
    }

    public Package importPackage(String module) {
        java.lang.Package result = this.scanner.importPackage(module);
        if (result == null) {
            try {
                return this.loader.load(ImportType.IMPLICIT, module);
            }
            catch (Exception e) {
                throw new InternalStateException("Problem importing '" + module + "'", e);
            }
        }
        return new NoPackage();
    }

    public Package importType(String module, String name) {
        String type = this.formatter.formatFullName(module, name);
        Class result = this.scanner.importType(type);
        if (result == null) {
            String outer = this.formatter.formatTopName(module, name);
            try {
                return this.loader.load(ImportType.EXPLICIT, outer, module);
            }
            catch (Exception e) {
                throw new InternalStateException("Problem importing '" + module + "." + name + "'", e);
            }
        }
        return new NoPackage();
    }

    public Package importType(String type) {
        Class result = this.scanner.importType(type);
        if (result == null) {
            String outer = this.formatter.formatTopName(type);
            try {
                return this.loader.load(ImportType.EXPLICIT, outer);
            }
            catch (Exception e) {
                throw new InternalStateException("Problem importing '" + type + "'", e);
            }
        }
        return new NoPackage();
    }
}

