/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Context;
import org.snapscript.core.NoStatement;
import org.snapscript.core.Statement;
import org.snapscript.core.link.ExceptionStatement;
import org.snapscript.core.link.FutureStatement;
import org.snapscript.core.link.PackageDefinition;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.ModuleRegistry;
import org.snapscript.core.module.Path;
import org.snapscript.core.scope.Scope;

public class StatementDefinition
implements PackageDefinition {
    private final AtomicReference<Statement> reference = new AtomicReference();
    private final Statement statement;
    private final Statement empty = new NoStatement();
    private final String name;
    private final Path path;

    public StatementDefinition(Statement statement, Path path, String name) {
        this.statement = statement;
        this.name = name;
        this.path = path;
    }

    @Override
    public Statement define(Scope scope, Path from) throws Exception {
        if (!this.path.equals(from)) {
            Executable executable;
            FutureTask<Statement> task;
            FutureStatement result;
            Statement value = this.reference.get();
            if (value == null && this.reference.compareAndSet(null, result = new FutureStatement(task = new FutureTask<Statement>(executable = new Executable(scope)), this.path))) {
                task.run();
                return result;
            }
            return this.reference.get();
        }
        return this.empty;
    }

    private class Executable
    implements Callable<Statement> {
        private final Scope scope;

        public Executable(Scope scope) {
            this.scope = scope;
        }

        @Override
        public Statement call() throws Exception {
            try {
                Module module = this.scope.getModule();
                Context context = module.getContext();
                ModuleRegistry registry = context.getRegistry();
                Module library = registry.addModule(StatementDefinition.this.name);
                Scope inner = library.getScope();
                StatementDefinition.this.statement.define(inner);
            }
            catch (Exception cause) {
                return new ExceptionStatement("Error occured compiling '" + StatementDefinition.this.path + "'", cause);
            }
            return StatementDefinition.this.statement;
        }
    }
}

