/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Context;
import org.snapscript.core.Statement;
import org.snapscript.core.link.ExceptionDefinition;
import org.snapscript.core.link.FutureDefinition;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageDefinition;
import org.snapscript.core.link.StatementDefinition;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.ModuleRegistry;
import org.snapscript.core.module.Path;
import org.snapscript.core.scope.Scope;

public class StatementPackage
implements Package {
    private final AtomicReference<PackageDefinition> reference;
    private final PackageDefinition definition;
    private final Statement statement;
    private final String name;
    private final Path path;

    public StatementPackage(Statement statement, Path path, String name) {
        this.definition = new StatementDefinition(statement, path, name);
        this.reference = new AtomicReference();
        this.statement = statement;
        this.name = name;
        this.path = path;
    }

    @Override
    public PackageDefinition create(Scope scope) throws Exception {
        Executable executable;
        FutureTask<PackageDefinition> task;
        FutureDefinition result;
        PackageDefinition value = this.reference.get();
        if (value == null && this.reference.compareAndSet(null, result = new FutureDefinition(task = new FutureTask<PackageDefinition>(executable = new Executable(scope, this.path, this.name)), this.path))) {
            task.run();
            return result;
        }
        return this.reference.get();
    }

    private class Executable
    implements Callable<PackageDefinition> {
        private final Scope scope;
        private final String name;
        private final Path path;

        public Executable(Scope scope, Path path, String name) {
            this.scope = scope;
            this.name = name;
            this.path = path;
        }

        @Override
        public PackageDefinition call() throws Exception {
            try {
                Module module = this.scope.getModule();
                Context context = module.getContext();
                ModuleRegistry registry = context.getRegistry();
                Module library = registry.addModule(this.name, this.path);
                Scope inner = library.getScope();
                StatementPackage.this.statement.create(inner);
            }
            catch (Exception cause) {
                return new ExceptionDefinition("Error occured defining '" + this.path + "'", cause);
            }
            return StatementPackage.this.definition;
        }
    }
}

