/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.module;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.common.LockProgress;
import org.snapscript.common.Progress;
import org.snapscript.core.Context;
import org.snapscript.core.ModifierType;
import org.snapscript.core.ResourceManager;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.function.Function;
import org.snapscript.core.link.ImportManager;
import org.snapscript.core.link.ImportProcessor;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.ModuleException;
import org.snapscript.core.module.ModuleScope;
import org.snapscript.core.module.ModuleType;
import org.snapscript.core.module.Path;
import org.snapscript.core.property.Property;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Phase;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeLoader;

public class ContextModule
implements Module {
    private final Cache<String, Module> modules;
    private final Cache<String, Type> types;
    private final Progress<Phase> progress;
    private final List<Annotation> annotations;
    private final List<Property> properties;
    private final List<Function> functions;
    private final List<Type> references;
    private final ImportProcessor manager;
    private final Context context;
    private final String prefix;
    private final Scope scope;
    private final Path path;
    private final Type type;
    private final int order;

    public ContextModule(Context context, Executor executor, Path path, String prefix, String local) {
        this(context, executor, path, prefix, local, 0);
    }

    public ContextModule(Context context, Executor executor, Path path, String prefix, String local, int order) {
        this.manager = new ImportProcessor(this, executor, path, prefix, local);
        this.annotations = new CopyOnWriteArrayList<Annotation>();
        this.functions = new CopyOnWriteArrayList<Function>();
        this.properties = new CopyOnWriteArrayList<Property>();
        this.references = new CopyOnWriteArrayList<Type>();
        this.modules = new CopyOnWriteCache<String, Module>();
        this.types = new CopyOnWriteCache<String, Type>();
        this.progress = new LockProgress<Phase>();
        this.type = new ModuleType(this);
        this.scope = new ModuleScope(this);
        this.context = context;
        this.prefix = prefix;
        this.order = order;
        this.path = path;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public ImportManager getManager() {
        return this.manager;
    }

    @Override
    public Progress<Phase> getProgress() {
        return this.progress;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<Function> getFunctions() {
        return this.functions;
    }

    @Override
    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public List<Type> getTypes() {
        return this.references;
    }

    @Override
    public Type addType(String name, int modifiers) {
        Type type = this.types.fetch(name);
        if (type != null) {
            throw new ModuleException("Type '" + this.prefix + "." + name + "' already defined");
        }
        try {
            TypeLoader loader = this.context.getLoader();
            if (loader != null) {
                type = loader.defineType(this.prefix, name, modifiers);
            }
            if (type != null) {
                this.types.cache(name, type);
                this.references.add(type);
            }
            return type;
        }
        catch (Exception e) {
            throw new ModuleException("Could not define '" + this.prefix + "." + name + "'", e);
        }
    }

    @Override
    public Module getModule(String name) {
        try {
            Module module = this.modules.fetch(name);
            if (module == null && !this.types.contains(name) && (module = this.manager.getModule(name)) != null) {
                this.modules.cache(name, module);
            }
            return module;
        }
        catch (Exception e) {
            throw new ModuleException("Could not find '" + name + "' in '" + this.prefix + "'", e);
        }
    }

    @Override
    public Type getType(String name) {
        try {
            Type type = this.types.fetch(name);
            if (type == null && !this.modules.contains(name) && (type = this.manager.getType(name)) != null) {
                this.types.cache(name, type);
                this.references.add(type);
            }
            return type;
        }
        catch (Exception e) {
            throw new ModuleException("Could not find '" + name + "' in '" + this.prefix + "'", e);
        }
    }

    @Override
    public Type getType(Class type) {
        try {
            TypeLoader loader = this.context.getLoader();
            if (loader != null) {
                return loader.loadType(type);
            }
            return null;
        }
        catch (Exception e) {
            throw new ModuleException("Could not load " + type, e);
        }
    }

    @Override
    public InputStream getResource(String path) {
        try {
            ResourceManager manager = this.context.getManager();
            if (manager != null) {
                return manager.getInputStream(path);
            }
            return null;
        }
        catch (Exception e) {
            throw new ModuleException("Could not load file '" + path + "'", e);
        }
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.prefix;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public int getModifiers() {
        return ModifierType.MODULE.mask;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public String toString() {
        return this.prefix;
    }
}

