/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.module;

import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.module.Path;
import org.snapscript.core.module.PathConverter;

public class FilePathConverter
implements PathConverter {
    private final Cache<String, String> modules = new CopyOnWriteCache<String, String>();
    private final Cache<String, Path> paths = new CopyOnWriteCache<String, Path>();
    private final String extension;

    public FilePathConverter() {
        this(".snap");
    }

    public FilePathConverter(String extension) {
        this.extension = extension;
    }

    @Override
    public Path createPath(String resource) {
        Path path = this.paths.fetch(resource);
        if (path == null) {
            Path match = this.convertModule(resource);
            String alias = match.getPath();
            this.paths.cache(resource, match);
            this.paths.cache(alias, match);
            return match;
        }
        return path;
    }

    @Override
    public String createModule(String resource) {
        String module = this.modules.fetch(resource);
        if (module == null) {
            String match = this.convertPath(resource);
            this.modules.cache(resource, match);
            this.modules.cache(match, match);
            return match;
        }
        return module;
    }

    private Path convertModule(String resource) {
        int suffix = resource.indexOf(this.extension);
        int prefix = resource.indexOf("/");
        if (suffix == -1) {
            int slash = resource.indexOf(46);
            if (slash != -1) {
                resource = resource.replace('.', '/');
            }
            return new Path("/" + resource + this.extension);
        }
        if (prefix != 0) {
            return new Path("/" + resource);
        }
        return new Path(resource);
    }

    private String convertPath(String path) {
        char value;
        String module = this.convertResource(path);
        int index = module.lastIndexOf(46);
        if (index != -1 && Character.isUpperCase(value = module.charAt(index + 1))) {
            return module.substring(0, index);
        }
        return module;
    }

    private String convertResource(String path) {
        int suffix = this.extension.length();
        int length = path.length();
        if (path.endsWith(this.extension)) {
            path = path.substring(0, length - suffix);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("\\")) {
            path = path.substring(1);
        }
        if (path.contains("\\")) {
            path = path.replace("\\", ".");
        }
        return path.replace('/', '.');
    }
}

