/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.module;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.core.Context;
import org.snapscript.core.NameFormatter;
import org.snapscript.core.error.InternalArgumentException;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.module.ContextModule;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;

public class ModuleAllocator {
    private final NameFormatter formatter = new NameFormatter();
    private final AtomicInteger counter = new AtomicInteger(1);
    private final Executor executor;
    private final Context context;
    private final int limit;

    public ModuleAllocator(Context context, Executor executor) {
        this(context, executor, 100000);
    }

    public ModuleAllocator(Context context, Executor executor, int limit) {
        this.executor = executor;
        this.context = context;
        this.limit = limit;
    }

    public Module allocate(String name, Path path) {
        if (name == null) {
            throw new InternalArgumentException("Module name was null");
        }
        String local = this.formatter.formatLocalName(name);
        int order = this.counter.getAndIncrement();
        if (order > this.limit) {
            throw new InternalStateException("Module limit of " + this.limit + " exceeded");
        }
        return new ContextModule(this.context, this.executor, path, name, local, order);
    }
}

