/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.module;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.snapscript.common.Progress;
import org.snapscript.core.Context;
import org.snapscript.core.NameChecker;
import org.snapscript.core.error.InternalArgumentException;
import org.snapscript.core.module.FilePathConverter;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.ModuleAllocator;
import org.snapscript.core.module.Path;
import org.snapscript.core.module.PathConverter;
import org.snapscript.core.type.Phase;
import org.snapscript.core.type.extend.ModuleExtender;

public class ModuleRegistry {
    private final Map<String, Module> modules;
    private final List<Module> references;
    private final ModuleAllocator allocator;
    private final PathConverter converter;
    private final ModuleExtender extender;
    private final NameChecker checker;

    public ModuleRegistry(Context context, Executor executor) {
        this(context, executor, 100000);
    }

    public ModuleRegistry(Context context, Executor executor, int limit) {
        this.allocator = new ModuleAllocator(context, executor, limit);
        this.modules = new ConcurrentHashMap<String, Module>();
        this.references = new CopyOnWriteArrayList<Module>();
        this.extender = new ModuleExtender(context);
        this.converter = new FilePathConverter();
        this.checker = new NameChecker(true);
    }

    public synchronized List<Module> getModules() {
        return this.references;
    }

    public synchronized Module getModule(String name) {
        if (name == null) {
            throw new InternalArgumentException("Module name was null");
        }
        return this.modules.get(name);
    }

    public synchronized Module addModule(String name) {
        if (name == null) {
            throw new InternalArgumentException("Module name was null");
        }
        Path path = this.converter.createPath(name);
        Module current = this.modules.get(name);
        if (current == null) {
            return this.addModule(name, path);
        }
        return current;
    }

    public synchronized Module addModule(String name, Path path) {
        if (name == null) {
            throw new InternalArgumentException("Module name was null");
        }
        Module current = this.modules.get(name);
        if (current == null) {
            Module module = this.allocator.allocate(name, path);
            Progress<Phase> progress = module.getProgress();
            if (!this.checker.isEntity(name)) {
                progress.done(Phase.COMPILE);
            }
            this.modules.put(name, module);
            this.extender.extend(module);
            this.references.add(module);
            return module;
        }
        return current;
    }
}

