/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.platform;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.platform.Platform;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;

public class PartialPlatform
implements Platform {
    private final Object empty = new Object();

    @Override
    public Invocation createSuperConstructor(Type type, Type real) {
        throw new IllegalStateException("Could not create '" + real + "' super constructor");
    }

    @Override
    public Invocation createSuperMethod(Type type, Method method) {
        throw new IllegalStateException("Could not create " + method + " super method");
    }

    @Override
    public Invocation createMethod(Type type, Method method) {
        return new DelegateMethodInvocation(method);
    }

    @Override
    public Invocation createConstructor(Type type, Constructor constructor) {
        return new DelegateConstructorInvocation(constructor);
    }

    public class DelegateConstructorInvocation
    implements Invocation {
        private final Constructor constructor;

        public DelegateConstructorInvocation(Constructor constructor) {
            this.constructor = constructor;
        }

        public Object invoke(Scope scope, Object value, Object ... arguments) {
            try {
                return this.constructor.newInstance(arguments);
            }
            catch (Throwable e) {
                throw new InternalStateException("Could not invoke constructor " + this.constructor, e);
            }
        }
    }

    public class DelegateMethodInvocation
    implements Invocation {
        private final Method method;

        public DelegateMethodInvocation(Method method) {
            this.method = method;
        }

        public Object invoke(Scope scope, Object value, Object ... arguments) {
            try {
                return this.method.invoke(value, arguments);
            }
            catch (Throwable e) {
                throw new InternalStateException("Could not invoke method " + this.method, e);
            }
        }
    }
}

