/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.platform;

import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.function.index.FunctionIndexer;
import org.snapscript.core.platform.PartialPlatform;
import org.snapscript.core.platform.Platform;
import org.snapscript.core.platform.PlatformClassLoader;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.core.type.TypeExtractor;

public class PlatformBuilder {
    private final AtomicReference<Platform> reference;
    private final PlatformClassLoader loader;
    private final FunctionIndexer resolver;
    private final ProxyWrapper wrapper;
    private final Platform partial;

    public PlatformBuilder(TypeExtractor extractor, ProxyWrapper wrapper, ThreadStack stack) {
        this.resolver = new FunctionIndexer(extractor, stack);
        this.loader = new PlatformClassLoader();
        this.partial = new PartialPlatform();
        this.reference = new AtomicReference();
        this.wrapper = wrapper;
    }

    public synchronized Platform create() {
        Platform platform = this.reference.get();
        if (platform == null) {
            try {
                Constructor constructor = this.loader.loadConstructor();
                Object instance = constructor.newInstance(this.resolver, this.wrapper);
                this.reference.set((Platform)instance);
            }
            catch (Exception e) {
                this.reference.set(this.partial);
            }
        }
        return this.reference.get();
    }
}

