/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.platform;

import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.Any;
import org.snapscript.core.ContextClassLoader;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.function.index.FunctionIndexer;
import org.snapscript.core.platform.PlatformNameBuilder;
import org.snapscript.core.platform.PlatformType;

public class PlatformClassLoader {
    private final AtomicReference<Constructor> reference = new AtomicReference();
    private final PlatformNameBuilder builder;
    private final ClassLoader loader = new ContextClassLoader(Any.class);

    public PlatformClassLoader() {
        this.builder = new PlatformNameBuilder();
    }

    public Constructor loadConstructor() {
        Constructor<?> constructor = this.reference.get();
        if (constructor == null) {
            try {
                PlatformType platform = PlatformType.resolveType();
                String type = this.builder.createFullName(platform);
                Class<?> value = this.loader.loadClass(type);
                constructor = value.getDeclaredConstructor(FunctionIndexer.class, ProxyWrapper.class);
                this.reference.set(constructor);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not load constructor", e);
            }
        }
        return constructor;
    }
}

