/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.platform;

import org.snapscript.core.platform.PlatformType;

public class PlatformNameBuilder {
    private static final String DEFAULT_SUFFIX = "Platform";
    private static final String DEFAULT_QUALIFIER = "platform";
    private final String qualifier;
    private final String suffix;

    public PlatformNameBuilder() {
        this(DEFAULT_QUALIFIER, DEFAULT_SUFFIX);
    }

    public PlatformNameBuilder(String qualifier, String suffix) {
        this.qualifier = qualifier;
        this.suffix = suffix;
    }

    public String createFullName(PlatformType platform) {
        String module = this.createPackage(platform);
        String name = this.createClassName(platform);
        return module + "." + name;
    }

    private String createClassName(PlatformType platform) {
        String name = platform.name();
        String token = name.toLowerCase();
        String prefix = token.substring(1);
        char first = name.charAt(0);
        return first + prefix + this.suffix;
    }

    private String createPackage(PlatformType platform) {
        String name = platform.name();
        String token = name.toLowerCase();
        return "org.snapscript." + this.qualifier + "." + token;
    }
}

