/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.property.Property;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Constant;

public class ConstantProperty
implements Property<Object> {
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final Constraint constraint;
    private final Constant constant;
    private final Type source;
    private final String name;
    private final int modifiers;

    public ConstantProperty(String name, Type source, Constraint constraint, Object value, int modifiers) {
        this.constant = new Constant(value);
        this.constraint = constraint;
        this.modifiers = modifiers;
        this.source = source;
        this.name = name;
    }

    @Override
    public List<Constraint> getGenerics() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }

    @Override
    public Type getHandle() {
        return null;
    }

    @Override
    public Type getSource() {
        return this.source;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers | ModifierType.CONSTANT.mask;
    }

    @Override
    public Object getValue(Object source) {
        return this.constant.getValue();
    }

    @Override
    public void setValue(Object source, Object value) {
        this.constant.setValue(value);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

