/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.property;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.snapscript.core.EntityCache;
import org.snapscript.core.property.Property;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;

public class PropertyExtractor {
    private final EntityCache<Set<Property>> cache = new EntityCache();
    private final TypeExtractor extractor;

    public PropertyExtractor(TypeExtractor extractor) {
        this.extractor = extractor;
    }

    public Set<Property> findProperties(Type type) {
        Set<Property> properties = this.cache.fetch(type);
        if (properties == null) {
            properties = this.findHierarchy(type);
            this.cache.cache(type, properties);
        }
        return properties;
    }

    private Set<Property> findHierarchy(Type type) {
        Set<Type> types = this.extractor.getTypes(type);
        if (!types.isEmpty()) {
            LinkedHashSet<String> done = new LinkedHashSet<String>();
            LinkedHashSet<Property> result = new LinkedHashSet<Property>();
            for (Type base : types) {
                Set<Property> map = this.findProperties(base, done);
                result.addAll(map);
            }
            return result;
        }
        return Collections.emptySet();
    }

    private Set<Property> findProperties(Type type, Set<String> done) {
        List<Property> properties = type.getProperties();
        if (!properties.isEmpty()) {
            LinkedHashSet<Property> result = new LinkedHashSet<Property>();
            for (Property property : properties) {
                String name = property.getName();
                if (!done.add(name)) continue;
                result.add(property);
            }
            return result;
        }
        return Collections.emptySet();
    }
}

