/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.scope.index;

import java.util.Arrays;
import java.util.Iterator;
import org.snapscript.common.EmptyIterator;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.scope.index.Local;
import org.snapscript.core.scope.index.Table;

public class ArrayTable
implements Table {
    private Constraint[] constraints;
    private Local[] locals;

    public ArrayTable() {
        this(0);
    }

    public ArrayTable(int count) {
        this.constraints = new Constraint[count];
        this.locals = new Local[count];
    }

    @Override
    public Iterator<Local> iterator() {
        if (this.locals.length > 0) {
            return new LocalIterator(this.locals);
        }
        return new EmptyIterator<Local>();
    }

    @Override
    public Local getLocal(int index) {
        if (index < this.locals.length && index >= 0) {
            return this.locals[index];
        }
        return null;
    }

    @Override
    public void addLocal(int index, Local local) {
        if (local == null) {
            throw new IllegalStateException("Local at index " + index + " is null");
        }
        if (index >= this.locals.length) {
            Local[] copy = new Local[index == 0 ? 2 : index * 2];
            for (int i = 0; i < this.locals.length; ++i) {
                copy[i] = this.locals[i];
            }
            this.locals = copy;
        }
        this.locals[index] = local;
    }

    @Override
    public Constraint getConstraint(int index) {
        if (index < this.constraints.length && index >= 0) {
            return this.constraints[index];
        }
        return null;
    }

    @Override
    public void addConstraint(int index, Constraint constraint) {
        if (constraint == null) {
            throw new IllegalStateException("Constraint at index " + index + " is null");
        }
        if (index >= this.constraints.length) {
            Constraint[] copy = new Constraint[index == 0 ? 2 : index * 2];
            for (int i = 0; i < this.constraints.length; ++i) {
                copy[i] = this.constraints[i];
            }
            this.constraints = copy;
        }
        this.constraints[index] = constraint;
    }

    public String toString() {
        return Arrays.toString(this.locals);
    }

    private static class LocalIterator
    implements Iterator<Local> {
        private Local[] table;
        private Local local;
        private int index;

        public LocalIterator(Local[] table) {
            this.table = table;
        }

        @Override
        public boolean hasNext() {
            while (this.local == null && this.index < this.table.length) {
                this.local = this.table[this.index++];
            }
            return this.local != null;
        }

        @Override
        public Local next() {
            Local next = null;
            if (this.hasNext()) {
                next = this.local;
                this.local = null;
            }
            return next;
        }
    }
}

