/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.scope.index;

import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.index.Local;

public class LocalConstant
extends Local {
    private final Constraint constraint;
    private final Object value;
    private final String name;

    public LocalConstant(Object value, String name) {
        this(value, name, Constraint.NONE);
    }

    public LocalConstant(Object value, String name, Constraint constraint) {
        this.constraint = constraint;
        this.value = value;
        this.name = name;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <T> T getValue() {
        return (T)this.value;
    }

    @Override
    public void setValue(Object value) {
        throw new InternalStateException("Illegal modification of constant");
    }

    public String toString() {
        return String.format("%s: %s", this.name, this.value);
    }
}

