/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.scope.index;

import org.snapscript.core.module.Module;
import org.snapscript.core.scope.CompoundScope;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.scope.index.ArrayTable;
import org.snapscript.core.scope.index.Index;
import org.snapscript.core.scope.index.LocalState;
import org.snapscript.core.scope.index.StackIndex;
import org.snapscript.core.scope.index.Table;
import org.snapscript.core.type.Type;

public class LocalScope
implements Scope {
    private final Index index;
    private final Table table;
    private final State state;
    private final Scope inner;
    private final Scope outer;

    public LocalScope(Scope inner, Scope outer) {
        this.state = new LocalState(inner);
        this.table = new ArrayTable();
        this.index = new StackIndex();
        this.inner = inner;
        this.outer = outer;
    }

    @Override
    public Scope getStack() {
        return new CompoundScope(this, this.outer);
    }

    @Override
    public Scope getScope() {
        return this.outer;
    }

    @Override
    public Type getHandle() {
        return this.inner.getType();
    }

    @Override
    public Type getType() {
        return this.inner.getType();
    }

    @Override
    public Module getModule() {
        return this.inner.getModule();
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public String toString() {
        return String.valueOf(this.state);
    }
}

