/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.scope.index;

import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.scope.index.Local;
import org.snapscript.core.scope.index.LocalScope;
import org.snapscript.core.scope.index.Table;
import org.snapscript.core.variable.Value;

public class LocalScopeExtractor {
    private final boolean reference;
    private final boolean extension;

    public LocalScopeExtractor(boolean reference, boolean extension) {
        this.reference = reference;
        this.extension = extension;
    }

    public Scope extract(Scope scope) {
        Scope outer = scope.getScope();
        if (this.extension) {
            return this.extract(scope, outer);
        }
        return this.extract(outer, outer);
    }

    public Scope extract(Scope original, Scope outer) {
        LocalScope capture = new LocalScope(original, outer);
        if (original != null) {
            Table table = original.getTable();
            State inner = capture.getState();
            for (Local local : table) {
                String name = local.getName();
                Value value = inner.getValue(name);
                if (value != null) continue;
                if (this.reference) {
                    inner.addValue(name, local);
                    continue;
                }
                Object object = local.getValue();
                Constraint constraint = local.getConstraint();
                Value constant = Value.getConstant(object, constraint);
                inner.addValue(name, constant);
            }
        }
        return capture;
    }
}

