/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.scope.index;

import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.scope.index.Local;
import org.snapscript.core.scope.index.LocalScopeChecker;
import org.snapscript.core.scope.index.Table;
import org.snapscript.core.variable.Value;

public class LocalScopeFinder {
    private final LocalScopeChecker checker = new LocalScopeChecker();

    public Value findValue(Scope scope, String name) {
        return this.findValue(scope, name, -1);
    }

    public Value findValue(Scope scope, String name, int depth) {
        if (depth == -1) {
            State state = scope.getState();
            Value value = state.getValue(name);
            if (this.checker.isValid(value)) {
                return value;
            }
        } else {
            Table table = scope.getTable();
            Local value = table.getLocal(depth);
            if (this.checker.isValid(value)) {
                return value;
            }
        }
        return null;
    }

    public Value findFunction(Scope scope, String name) {
        return this.findFunction(scope, name, -1);
    }

    public Value findFunction(Scope scope, String name, int depth) {
        if (depth == -1) {
            State state = scope.getState();
            Value value = state.getValue(name);
            if (!this.checker.isGenerated(value)) {
                return value;
            }
        } else {
            Table table = scope.getTable();
            Local value = table.getLocal(depth);
            if (!this.checker.isGenerated(value)) {
                return value;
            }
        }
        return null;
    }
}

