/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.scope.index;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.snapscript.common.Cache;
import org.snapscript.common.CompoundIterator;
import org.snapscript.common.HashCache;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.scope.index.Local;
import org.snapscript.core.variable.Value;

public class LocalState
implements State {
    private final Cache<String, Constraint> constraints = new HashCache<String, Constraint>();
    private final Cache<String, Value> values = new HashCache<String, Value>();
    private final Scope scope;

    public LocalState(Scope scope) {
        this(scope, null);
    }

    public LocalState(Scope scope, List<Local> stack) {
        this.scope = scope;
    }

    @Override
    public Iterator<String> iterator() {
        Set<String> keys = this.values.keySet();
        Iterator<String> inner = keys.iterator();
        if (this.scope != null) {
            State state = this.scope.getState();
            Iterator outer = state.iterator();
            return new CompoundIterator<String>(inner, outer);
        }
        return inner;
    }

    @Override
    public Value getValue(String name) {
        Value value = this.values.fetch(name);
        if (value == null && this.scope != null) {
            State state = this.scope.getState();
            if (state == null) {
                throw new InternalStateException("Scope for '" + name + "' does not exist");
            }
            return state.getValue(name);
        }
        return value;
    }

    @Override
    public void addValue(String name, Value value) {
        Value variable = this.values.fetch(name);
        if (variable != null) {
            throw new InternalStateException("Variable '" + name + "' already exists");
        }
        this.values.cache(name, value);
    }

    @Override
    public Constraint getConstraint(String name) {
        Constraint constraint = this.constraints.fetch(name);
        if (constraint == null && this.scope != null) {
            State state = this.scope.getState();
            if (state == null) {
                throw new InternalStateException("Scope for '" + name + "' does not exist");
            }
            return state.getConstraint(name);
        }
        return constraint;
    }

    @Override
    public void addConstraint(String name, Constraint constraint) {
        Constraint existing = this.constraints.fetch(name);
        if (existing != null) {
            throw new InternalStateException("Constraint '" + name + "' already exists");
        }
        this.constraints.cache(name, constraint);
    }

    public String toString() {
        return String.valueOf(this.values);
    }
}

