/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.scope.index;

import java.util.Iterator;
import org.snapscript.common.ArrayStack;
import org.snapscript.common.Cache;
import org.snapscript.common.HashCache;
import org.snapscript.common.Stack;
import org.snapscript.core.scope.index.Index;

public class StackIndex
implements Index {
    private final Cache<String, Integer> locals = new HashCache<String, Integer>();
    private final Stack<String> stack = new ArrayStack<String>(0);

    @Override
    public Iterator<String> iterator() {
        return this.locals.keySet().iterator();
    }

    @Override
    public int get(String name) {
        Integer index = this.locals.fetch(name);
        if (index != null) {
            return index;
        }
        return -1;
    }

    @Override
    public int index(String name) {
        Integer index = this.locals.fetch(name);
        if (index != null) {
            throw new IllegalStateException("Duplicate variable '" + name + "' in scope");
        }
        int size = this.locals.size();
        this.locals.cache(name, size);
        this.stack.push(name);
        return size;
    }

    @Override
    public void reset(int index) {
        int size;
        for (int i = size = this.locals.size(); i > index; --i) {
            String name = this.stack.pop();
            this.locals.take(name);
        }
    }

    @Override
    public int size() {
        return this.locals.size();
    }

    public String toString() {
        return String.valueOf(this.locals);
    }
}

