/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.scope.instance;

import java.util.Iterator;
import java.util.Set;
import org.snapscript.common.Cache;
import org.snapscript.common.CompoundIterator;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.common.HashCache;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.State;
import org.snapscript.core.scope.instance.Instance;
import org.snapscript.core.variable.Value;

public class InstanceState
implements State {
    private final Cache<String, Constraint> constraints = new HashCache<String, Constraint>();
    private final Cache<String, Value> values = new CopyOnWriteCache<String, Value>();
    private final Instance instance;

    public InstanceState(Instance instance) {
        this.instance = instance;
    }

    @Override
    public Iterator<String> iterator() {
        Set<String> keys = this.values.keySet();
        Iterator<String> inner = keys.iterator();
        if (this.instance != null) {
            State state = this.instance.getState();
            Iterator outer = state.iterator();
            return new CompoundIterator<String>(inner, outer);
        }
        return inner;
    }

    @Override
    public Value getValue(String name) {
        Value value = this.values.fetch(name);
        if (value == null) {
            State state = this.instance.getState();
            if (state == null) {
                throw new InternalStateException("Scope for '" + name + "' does not exist");
            }
            value = state.getValue(name);
            if (value != null) {
                this.values.cache(name, value);
            }
        }
        return value;
    }

    @Override
    public void addValue(String name, Value value) {
        Value existing = this.values.fetch(name);
        if (existing != null) {
            throw new InternalStateException("Variable '" + name + "' already exists");
        }
        this.values.cache(name, value);
    }

    @Override
    public Constraint getConstraint(String name) {
        Constraint constraint = this.constraints.fetch(name);
        if (constraint == null) {
            State state = this.instance.getState();
            if (state == null) {
                throw new InternalStateException("Scope for '" + name + "' does not exist");
            }
            return state.getConstraint(name);
        }
        return constraint;
    }

    @Override
    public void addConstraint(String name, Constraint constraint) {
        Constraint existing = this.constraints.fetch(name);
        if (existing != null) {
            throw new InternalStateException("Constraint '" + name + "' already exists");
        }
        this.constraints.cache(name, constraint);
    }

    public String toString() {
        return String.valueOf(this.values);
    }
}

