/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.scope.instance;

import org.snapscript.core.convert.proxy.ScopeProxy;
import org.snapscript.core.module.Module;
import org.snapscript.core.platform.Bridge;
import org.snapscript.core.scope.State;
import org.snapscript.core.scope.index.ArrayTable;
import org.snapscript.core.scope.index.Index;
import org.snapscript.core.scope.index.StackIndex;
import org.snapscript.core.scope.index.Table;
import org.snapscript.core.scope.instance.CompoundInstance;
import org.snapscript.core.scope.instance.Instance;
import org.snapscript.core.scope.instance.InstanceState;
import org.snapscript.core.type.Type;

public class ObjectInstance
implements Instance {
    private final ScopeProxy proxy;
    private final Instance base;
    private final Bridge object;
    private final Module module;
    private final Table table;
    private final Index index;
    private final State state;
    private final Type type;

    public ObjectInstance(Module module, Instance base, Bridge object, Type type) {
        this.state = new InstanceState(base);
        this.proxy = new ScopeProxy(this);
        this.table = new ArrayTable();
        this.index = new StackIndex();
        this.object = object;
        this.module = module;
        this.type = type;
        this.base = base;
    }

    @Override
    public Instance getStack() {
        return new CompoundInstance(this.module, this, this, this.type);
    }

    @Override
    public Object getProxy() {
        return this.proxy.getProxy();
    }

    @Override
    public Instance getScope() {
        return this;
    }

    @Override
    public Instance getSuper() {
        return this.base;
    }

    @Override
    public Bridge getBridge() {
        return this.object;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public Type getHandle() {
        return this.type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public String toString() {
        return this.type.toString();
    }
}

