/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.stack;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.common.ArrayStack;
import org.snapscript.common.Stack;
import org.snapscript.core.function.Function;
import org.snapscript.core.stack.StackOverflowException;
import org.snapscript.core.trace.Trace;

public class StackTrace
implements Iterable {
    private final Stack<Function> functions = new ArrayStack<Function>();
    private final Stack<Object> stack = new ArrayStack<Object>();
    private final AtomicInteger depth = new AtomicInteger();
    private final int threshold;

    public StackTrace() {
        this(40);
    }

    public StackTrace(int threshold) {
        this.threshold = threshold;
    }

    public Function current() {
        return this.functions.peek();
    }

    public Iterator iterator() {
        return this.stack.iterator();
    }

    public void before(Trace trace) {
        this.stack.push(trace);
    }

    public void before(Function function) {
        int size = this.depth.get();
        if (size + 1 > this.threshold) {
            throw new StackOverflowException("Stack overflow for " + function);
        }
        this.depth.getAndIncrement();
        this.functions.push(function);
        this.stack.push(function);
    }

    public void after(Trace trace) {
        Object next;
        while (!this.stack.isEmpty() && (next = this.stack.pop()) != trace) {
            Function context = this.functions.peek();
            if (next != context) continue;
            this.functions.pop();
            this.depth.getAndDecrement();
        }
    }

    public void after(Function function) {
        while (!this.stack.isEmpty()) {
            Object next = this.stack.pop();
            if (next == function) {
                this.functions.pop();
                this.depth.getAndDecrement();
                break;
            }
            Function context = this.functions.peek();
            if (next != context) continue;
            this.functions.pop();
            this.depth.getAndDecrement();
        }
    }

    public void clear() {
        this.stack.clear();
    }
}

