/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.stack;

import java.util.List;
import org.snapscript.core.stack.OriginTraceExtractor;
import org.snapscript.core.stack.StackElementConverter;
import org.snapscript.core.stack.StackTrace;

public class StackTraceBuilder {
    private final OriginTraceExtractor extractor = new OriginTraceExtractor();
    private final StackElementConverter builder = new StackElementConverter();
    private final StackTraceElement[] empty = new StackTraceElement[0];

    public StackTraceElement[] create(StackTrace stack) {
        return this.create(stack, null);
    }

    public StackTraceElement[] create(StackTrace stack, Throwable origin) {
        Thread thread = Thread.currentThread();
        List<StackTraceElement> list = this.extractor.extract(origin);
        List<StackTraceElement> context = this.builder.create(stack);
        StackTraceElement[] actual = thread.getStackTrace();
        for (StackTraceElement trace : context) {
            list.add(trace);
        }
        for (int i = 1; i < actual.length; ++i) {
            StackTraceElement trace;
            trace = actual[i];
            String source = trace.getClassName();
            if (source.startsWith("org.snapscript.")) continue;
            list.add(trace);
        }
        return list.toArray(this.empty);
    }
}

