/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.stack;

import org.snapscript.core.function.Function;
import org.snapscript.core.stack.StackTrace;
import org.snapscript.core.stack.StackTraceBuilder;
import org.snapscript.core.stack.ThreadLocalStack;
import org.snapscript.core.trace.Trace;

public class ThreadStack {
    private final StackTraceBuilder builder = new StackTraceBuilder();
    private final ThreadLocalStack local = new ThreadLocalStack();

    public StackTraceElement[] build() {
        return this.build(null);
    }

    public StackTraceElement[] build(Throwable cause) {
        StackTrace stack = (StackTrace)this.local.get();
        if (cause != null) {
            return this.builder.create(stack, cause);
        }
        return this.builder.create(stack);
    }

    public void before(Trace trace) {
        StackTrace stack = (StackTrace)this.local.get();
        if (trace != null) {
            stack.before(trace);
        }
    }

    public void before(Function function) {
        StackTrace stack = (StackTrace)this.local.get();
        if (function != null) {
            stack.before(function);
        }
    }

    public void after(Trace trace) {
        StackTrace stack = (StackTrace)this.local.get();
        if (trace != null) {
            stack.after(trace);
        }
    }

    public void after(Function function) {
        StackTrace stack = (StackTrace)this.local.get();
        if (function != null) {
            stack.after(function);
        }
    }

    public Function current() {
        StackTrace stack = (StackTrace)this.local.get();
        return stack.current();
    }

    public void clear() {
        StackTrace stack = (StackTrace)this.local.get();
        stack.clear();
    }
}

