/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.trace;

import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.trace.TraceType;

public class Trace {
    private final TraceType type;
    private final Module module;
    private final Path path;
    private final int line;

    public static Trace getNative(Module module, Path path) {
        return new Trace(TraceType.NATIVE, module, path, -2);
    }

    public static Trace getConstruct(Module module, Path path, int line) {
        return new Trace(TraceType.CONSTRUCT, module, path, line);
    }

    public static Trace getReference(Module module, Path path, int line) {
        return new Trace(TraceType.REFERENCE, module, path, line);
    }

    public static Trace getInvoke(Module module, Path path, int line) {
        return new Trace(TraceType.INVOKE, module, path, line);
    }

    public static Trace getNormal(Module module, Path path, int line) {
        return new Trace(TraceType.NORMAL, module, path, line);
    }

    public static Trace getDefine(Module module, Path path, int line) {
        return new Trace(TraceType.DEFINE, module, path, line);
    }

    public static Trace getImport(Module module, Path path, int line) {
        return new Trace(TraceType.IMPORT, module, path, line);
    }

    public static Trace getAllocate(Module module, Path path, int line) {
        return new Trace(TraceType.ALLOCATE, module, path, line);
    }

    public static Trace getDebug(Module module, Path path, int line) {
        return new Trace(TraceType.DEBUG, module, path, line);
    }

    public Trace(TraceType type, Module module, Path path, int line) {
        this.module = module;
        this.path = path;
        this.line = line;
        this.type = type;
    }

    public TraceType getType() {
        return this.type;
    }

    public Module getModule() {
        return this.module;
    }

    public Path getPath() {
        return this.path;
    }

    public int getLine() {
        return this.line;
    }

    public String toString() {
        return String.format("%s at line %s", this.path, this.line);
    }
}

