/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.trace;

import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.variable.Value;

public class TraceEvaluation
extends Evaluation {
    private final TraceInterceptor interceptor;
    private final Evaluation evaluation;
    private final Trace trace;

    public TraceEvaluation(TraceInterceptor interceptor, Evaluation evaluation, Trace trace) {
        this.interceptor = interceptor;
        this.evaluation = evaluation;
        this.trace = trace;
    }

    @Override
    public void define(Scope scope) throws Exception {
        this.evaluation.define(scope);
    }

    @Override
    public Constraint compile(Scope scope, Constraint left) throws Exception {
        try {
            return this.evaluation.compile(scope, left);
        }
        catch (Exception cause) {
            this.interceptor.traceCompileError(scope, this.trace, cause);
            return Constraint.NONE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value evaluate(Scope scope, Value left) throws Exception {
        try {
            this.interceptor.traceBefore(scope, this.trace);
            Value value = this.evaluation.evaluate(scope, left);
            return value;
        }
        finally {
            this.interceptor.traceAfter(scope, this.trace);
        }
    }
}

