/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.trace;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceErrorCollector;
import org.snapscript.core.trace.TraceListener;

public class TraceInterceptor
implements TraceListener {
    private final Set<TraceListener> listeners = new CopyOnWriteArraySet<TraceListener>();
    private final TraceErrorCollector collector;
    private final ThreadStack stack;

    public TraceInterceptor(TraceErrorCollector collector, ThreadStack stack) {
        this.collector = collector;
        this.stack = stack;
    }

    @Override
    public void traceBefore(Scope scope, Trace trace) {
        this.stack.before(trace);
        if (!this.listeners.isEmpty()) {
            for (TraceListener listener : this.listeners) {
                listener.traceBefore(scope, trace);
            }
        }
    }

    @Override
    public void traceAfter(Scope scope, Trace trace) {
        this.stack.after(trace);
        if (!this.listeners.isEmpty()) {
            for (TraceListener listener : this.listeners) {
                listener.traceAfter(scope, trace);
            }
        }
    }

    @Override
    public void traceCompileError(Scope scope, Trace trace, Exception cause) {
        this.collector.compileError(cause, trace);
        if (!this.listeners.isEmpty()) {
            for (TraceListener listener : this.listeners) {
                listener.traceCompileError(scope, trace, cause);
            }
        }
    }

    @Override
    public void traceRuntimeError(Scope scope, Trace trace, Exception cause) {
        this.collector.runtimeError(cause, trace);
        if (!this.listeners.isEmpty()) {
            for (TraceListener listener : this.listeners) {
                listener.traceRuntimeError(scope, trace, cause);
            }
        }
    }

    public void register(TraceListener listener) {
        this.listeners.add(listener);
    }

    public void remove(TraceListener listener) {
        this.listeners.remove(listener);
    }

    public void clear() {
        this.listeners.clear();
    }
}

