/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.trace;

import org.snapscript.core.Execution;
import org.snapscript.core.NoExecution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.Reason;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;

public class TraceStatement
extends Statement {
    private final TraceInterceptor interceptor;
    private final ErrorHandler handler;
    private final Execution execution = new NoExecution(Result.NORMAL);
    private final Statement statement;
    private final Trace trace;

    public TraceStatement(TraceInterceptor interceptor, ErrorHandler handler, Statement statement, Trace trace) {
        this.interceptor = interceptor;
        this.statement = statement;
        this.handler = handler;
        this.trace = trace;
    }

    @Override
    public void create(Scope scope) throws Exception {
        try {
            this.statement.create(scope);
        }
        catch (Exception cause) {
            this.interceptor.traceCompileError(scope, this.trace, cause);
        }
    }

    @Override
    public boolean define(Scope scope) throws Exception {
        try {
            return this.statement.define(scope);
        }
        catch (Exception cause) {
            this.interceptor.traceCompileError(scope, this.trace, cause);
            return true;
        }
    }

    @Override
    public Execution compile(Scope scope, Constraint returns) throws Exception {
        try {
            Execution execution = this.statement.compile(scope, returns);
            return new TraceExecution(this.interceptor, this.handler, execution, this.trace);
        }
        catch (Exception cause) {
            this.interceptor.traceCompileError(scope, this.trace, cause);
            return this.execution;
        }
    }

    private static class TraceExecution
    extends Execution {
        private final TraceInterceptor interceptor;
        private final ErrorHandler handler;
        private final Execution execution;
        private final Trace trace;

        public TraceExecution(TraceInterceptor interceptor, ErrorHandler handler, Execution execution, Trace trace) {
            this.interceptor = interceptor;
            this.execution = execution;
            this.handler = handler;
            this.trace = trace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result execute(Scope scope) throws Exception {
            try {
                this.interceptor.traceBefore(scope, this.trace);
                Result result = this.execution.execute(scope);
                return result;
            }
            catch (Exception cause) {
                this.interceptor.traceRuntimeError(scope, this.trace, cause);
                Result result = this.handler.handleInternalError(Reason.THROW, scope, cause);
                return result;
            }
            finally {
                this.interceptor.traceAfter(scope, this.trace);
            }
        }
    }
}

