/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.trace;

import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceTypeState;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeBody;
import org.snapscript.core.type.TypePart;
import org.snapscript.core.type.TypeState;

public class TraceTypePart
extends TypePart {
    private final TraceInterceptor interceptor;
    private final ErrorHandler handler;
    private final TypePart part;
    private final Trace trace;

    public TraceTypePart(TraceInterceptor interceptor, ErrorHandler handler, TypePart part, Trace trace) {
        this.interceptor = interceptor;
        this.handler = handler;
        this.trace = trace;
        this.part = part;
    }

    @Override
    public void create(TypeBody body, Type type, Scope scope) throws Exception {
        try {
            this.part.create(body, type, scope);
        }
        catch (Exception cause) {
            this.interceptor.traceCompileError(scope, this.trace, cause);
        }
    }

    @Override
    public TypeState define(TypeBody body, Type type, Scope scope) throws Exception {
        try {
            TypeState statement = this.part.define(body, type, scope);
            if (statement != null) {
                return new TraceTypeState(this.interceptor, this.handler, statement, this.trace);
            }
        }
        catch (Exception cause) {
            this.interceptor.traceCompileError(scope, this.trace, cause);
        }
        return null;
    }
}

