/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.trace;

import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.Reason;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.type.Category;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeState;

public class TraceTypeState
extends TypeState {
    private final TraceInterceptor interceptor;
    private final ErrorHandler handler;
    private final TypeState state;
    private final Trace trace;

    public TraceTypeState(TraceInterceptor interceptor, ErrorHandler handler, TypeState state, Trace trace) {
        this.interceptor = interceptor;
        this.handler = handler;
        this.state = state;
        this.trace = trace;
    }

    @Override
    public Category define(Scope scope, Type type) throws Exception {
        try {
            return this.state.define(scope, type);
        }
        catch (Exception cause) {
            this.interceptor.traceCompileError(scope, this.trace, cause);
            return Category.OTHER;
        }
    }

    @Override
    public void compile(Scope scope, Type type) throws Exception {
        try {
            this.state.compile(scope, type);
        }
        catch (Exception cause) {
            this.interceptor.traceCompileError(scope, this.trace, cause);
        }
    }

    @Override
    public void allocate(Scope scope, Type type) throws Exception {
        try {
            this.state.allocate(scope, type);
        }
        catch (Exception cause) {
            this.handler.handleInternalError(Reason.THROW, scope, cause, this.trace);
        }
    }

    @Override
    public Result execute(Scope scope, Type type) throws Exception {
        try {
            return this.state.execute(scope, type);
        }
        catch (Exception cause) {
            this.handler.handleInternalError(Reason.THROW, scope, cause, this.trace);
            return null;
        }
    }
}

