/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type;

import org.snapscript.core.ResourceManager;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.link.ImportScanner;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageLinker;
import org.snapscript.core.link.PackageLoader;
import org.snapscript.core.link.PackageManager;
import org.snapscript.core.module.ModuleRegistry;
import org.snapscript.core.platform.PlatformProvider;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeCache;
import org.snapscript.core.type.TypeExtractor;
import org.snapscript.core.type.TypeLoader;
import org.snapscript.core.type.extend.ClassExtender;
import org.snapscript.core.type.index.TypeIndexer;

public class CacheTypeLoader
implements TypeLoader {
    private final ImportScanner scanner;
    private final TypeExtractor extractor = new TypeExtractor(this);
    private final ClassExtender extender;
    private final PlatformProvider provider;
    private final PackageManager manager;
    private final PackageLoader loader;
    private final TypeIndexer indexer;
    private final TypeCache cache;

    public CacheTypeLoader(PackageLinker linker, ModuleRegistry registry, ResourceManager manager, ProxyWrapper wrapper, ThreadStack stack) {
        this.provider = new PlatformProvider(this.extractor, wrapper, stack);
        this.scanner = new ImportScanner(manager);
        this.extender = new ClassExtender(this);
        this.indexer = new TypeIndexer(registry, this.scanner, this.extender, this.provider);
        this.loader = new PackageLoader(linker, manager);
        this.manager = new PackageManager(this.loader, this.scanner);
        this.cache = new TypeCache(this.indexer);
    }

    @Override
    public Package importPackage(String module) {
        return this.manager.importPackage(module);
    }

    @Override
    public Package importType(String type) {
        return this.manager.importType(type);
    }

    @Override
    public Package importType(String module, String name) {
        return this.manager.importType(module, name);
    }

    @Override
    public Type defineType(String module, String name, int modifiers) {
        return this.indexer.defineType(module, name, modifiers);
    }

    @Override
    public Type loadType(String module, String name) {
        return this.cache.fetch(module, name);
    }

    @Override
    public Type loadArrayType(String module, String name, int size) {
        return this.indexer.loadArrayType(module, name, size);
    }

    @Override
    public Type loadType(String type) {
        return this.cache.fetch(type);
    }

    @Override
    public Type loadType(Class type) {
        return this.cache.fetch(type);
    }
}

