/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type;

import org.snapscript.common.LazyBuilder;
import org.snapscript.common.LazyCache;
import org.snapscript.core.NameFormatter;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.index.TypeIndexer;

public class TypeCache {
    private final NameFormatter formatter;
    private final StringResolver strings;
    private final ClassResolver classes;

    public TypeCache(TypeIndexer indexer) {
        this.strings = new StringResolver(indexer);
        this.classes = new ClassResolver(indexer);
        this.formatter = new NameFormatter();
    }

    public Type fetch(String module, String name) {
        String type = this.formatter.formatFullName(module, name);
        return this.strings.resolve(type);
    }

    public Type fetch(String type) {
        return this.strings.resolve(type);
    }

    public Type fetch(Class type) {
        return this.classes.resolve(type);
    }

    private static class ClassResolver
    implements LazyBuilder<Class, Type> {
        private final LazyCache<Class, Type> cache = new LazyCache<Class, Type>(this);
        private final TypeIndexer indexer;

        public ClassResolver(TypeIndexer indexer) {
            this.indexer = indexer;
        }

        public Type resolve(Class type) {
            return this.cache.fetch(type);
        }

        @Override
        public Type create(Class type) {
            return this.indexer.loadType(type);
        }
    }

    private static class StringResolver
    implements LazyBuilder<String, Type> {
        private final LazyCache<String, Type> cache = new LazyCache<String, Type>(this);
        private final TypeIndexer indexer;

        public StringResolver(TypeIndexer indexer) {
            this.indexer = indexer;
        }

        public Type resolve(String name) {
            return this.cache.fetch(name);
        }

        @Override
        public Type create(String type) {
            return this.indexer.loadType(type);
        }
    }
}

