/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.snapscript.core.Handle;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.property.Property;
import org.snapscript.core.property.PropertyExtractor;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeLoader;
import org.snapscript.core.type.TypeTraverser;

public class TypeExtractor {
    private final PropertyExtractor extractor = new PropertyExtractor(this);
    private final TypeTraverser traverser = new TypeTraverser();
    private final TypeLoader loader;

    public TypeExtractor(TypeLoader loader) {
        this.loader = loader;
    }

    public Type getType(Class type) {
        if (type != null) {
            return this.loader.loadType(type);
        }
        return null;
    }

    public Type getType(Object value) {
        if (value != null) {
            Handle handle;
            Type match;
            Class<?> type = value.getClass();
            if (Handle.class.isAssignableFrom(type) && (match = (handle = (Handle)value).getHandle()) != null) {
                return match;
            }
            return this.getType(type);
        }
        return null;
    }

    public Type getType(Type parent, String name) {
        if (parent != null) {
            return this.traverser.findEnclosing(parent, name);
        }
        return null;
    }

    public Set<Type> getTypes(Object value) {
        Type type = this.getType(value);
        if (type != null) {
            return this.traverser.findHierarchy(type);
        }
        return Collections.emptySet();
    }

    public Set<Type> getTypes(Type type) {
        if (type != null) {
            return this.traverser.findHierarchy(type);
        }
        return Collections.emptySet();
    }

    public Set<Property> getProperties(Type type) {
        if (type != null) {
            return this.extractor.findProperties(type);
        }
        return Collections.emptySet();
    }

    public Set<Property> getProperties(Object value) {
        Type type = this.getType(value);
        if (type != null) {
            return this.extractor.findProperties(type);
        }
        return Collections.emptySet();
    }

    public List<Constraint> getTypes(Type type, Type base) {
        if (type != null && base != null) {
            return this.traverser.findPath(type, base);
        }
        return Collections.emptyList();
    }
}

