/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.snapscript.core.EntityCache;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;

public class TypeTraverser {
    private final EntityCache<Set<Type>> types = new EntityCache();

    public Set<Type> findHierarchy(Type type) {
        Set<Type> list = this.types.fetch(type);
        if (list == null) {
            list = this.findHierarchy(type, type);
            this.types.cache(type, list);
        }
        return list;
    }

    private Set<Type> findHierarchy(Type root, Type type) {
        LinkedHashSet<Type> list = new LinkedHashSet<Type>();
        if (type != null) {
            this.findHierarchy(root, type, list);
        }
        return Collections.unmodifiableSet(list);
    }

    private Set<Type> findHierarchy(Type root, Type type, Set<Type> list) {
        List<Constraint> types = type.getTypes();
        Scope scope = type.getScope();
        if (list.add(type)) {
            for (Constraint entry : types) {
                Type match = entry.getType(scope);
                if (match == root) {
                    throw new InternalStateException("Hierarchy for '" + type + "' contains a cycle");
                }
                this.findHierarchy(root, match, list);
            }
        }
        return list;
    }

    public Type findEnclosing(Type type, String name) {
        LinkedHashSet<Type> done = new LinkedHashSet<Type>();
        if (type != null) {
            return this.findEnclosing(type, name, done);
        }
        return null;
    }

    private Type findEnclosing(Type type, String name, Set<Type> done) {
        Module module = type.getModule();
        while (type != null) {
            String prefix = type.getName();
            Type result = module.getType(prefix + "$" + name);
            if (result == null) {
                result = this.findHierarchy(type, name, done);
            }
            if (result != null) {
                return result;
            }
            type = type.getOuter();
        }
        return null;
    }

    private Type findHierarchy(Type type, String name, Set<Type> done) {
        List<Constraint> types = type.getTypes();
        Scope scope = type.getScope();
        for (Constraint base : types) {
            Type result;
            Type match = base.getType(scope);
            if (!done.add(match) || (result = this.findEnclosing(match, name, done)) == null) continue;
            return result;
        }
        return null;
    }

    public List<Constraint> findPath(Type constraint, Type require) {
        ArrayList<Constraint> path = new ArrayList<Constraint>();
        this.findPath(constraint, require, path);
        Collections.reverse(path);
        return path;
    }

    public boolean findPath(Type constraint, Type require, List<Constraint> path) {
        Scope scope = require.getScope();
        if (constraint != require) {
            List<Constraint> types = constraint.getTypes();
            for (Constraint base : types) {
                Type next = base.getType(scope);
                if (!this.findPath(next, require, path)) continue;
                path.add(base);
                return true;
            }
            return false;
        }
        return true;
    }
}

