/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.type.extend;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.core.function.Function;
import org.snapscript.core.type.TypeLoader;
import org.snapscript.core.type.extend.DateExtension;
import org.snapscript.core.type.extend.ExtensionRegistry;
import org.snapscript.core.type.extend.FileExtension;
import org.snapscript.core.type.extend.InputStreamExtension;
import org.snapscript.core.type.extend.IteratorExtension;
import org.snapscript.core.type.extend.OutputStreamExtension;
import org.snapscript.core.type.extend.ReaderExtension;
import org.snapscript.core.type.extend.URLConnectionExtension;
import org.snapscript.core.type.extend.URLExtension;
import org.snapscript.core.type.extend.WriterExtension;

public class ClassExtender {
    private final ExtensionRegistry registry;
    private final AtomicBoolean done;

    public ClassExtender(TypeLoader loader) {
        this.registry = new ExtensionRegistry(loader);
        this.done = new AtomicBoolean();
    }

    public List<Function> extend(Class type) {
        if (!this.done.get()) {
            this.registry.register(File.class, FileExtension.class);
            this.registry.register(Date.class, DateExtension.class);
            this.registry.register(Reader.class, ReaderExtension.class);
            this.registry.register(Writer.class, WriterExtension.class);
            this.registry.register(InputStream.class, InputStreamExtension.class);
            this.registry.register(OutputStream.class, OutputStreamExtension.class);
            this.registry.register(URLConnection.class, URLConnectionExtension.class);
            this.registry.register(URL.class, URLExtension.class);
            this.registry.register(Iterator.class, IteratorExtension.class);
            this.done.set(true);
        }
        return this.registry.extract(type);
    }
}

